set more off

* RUN THIS CODE AFTER RUNNING THE RDP_variable_definition_code SCRIPT.

*******************************************************************************
******************* RUN THIS INITIAL CODE ONCE BEFORE RUNNING OTHER REGRESSIONS
*******************************************************************************

************ This is a program for the aggregate time series regressions
* INput 1 is DVs; 2 is MP vars (MP1 of MP2); 3 is condition. See below where 'agg_ts_reg' is run for an example.
program define agg_ts_reg
	preserve
		collapse (sum) appr_occ_tot appr_inv_tot appr_occ_io appr_inv_io ///
		(mean) lsize lcapitalratio lfunding MacP1 MacP2 dcashrate GDP houseprice qtr_dum* ///
		if `3' == 1, by(qtr)	
		* Regenerate approvals DVs
		/*
		gen dl_OO = log(appr_occ_tot) - log(appr_occ_tot[_n-1])
		gen dl_inv = log(appr_inv_tot) - log(appr_inv_tot[_n-1])
		gen tot_appr = appr_occ_tot + appr_inv_tot
		gen dl_loans = log(tot_appr) - log(tot_appr[_n-1])
		gen IO_appr = appr_occ_io + appr_inv_io
		gen dl_IO = log(IO_appr) - log(IO_appr[_n-1])
		gen PI_apr = tot_appr - IO_appr
		gen dl_PI = log(PI_apr) - log(PI_apr[_n-1])
		*/
		gen dl_OO = appr_occ_tot/appr_occ_tot[_n-1] - 1
		gen ddl_OO = dl_OO - dl_OO[_n-1]
		gen dl_inv = appr_inv_tot/appr_inv_tot[_n-1] - 1
		gen ddl_inv = dl_inv - dl_inv[_n-1]
		gen tot_appr = appr_occ_tot + appr_inv_tot
		gen dl_loans = tot_appr/tot_appr[_n-1] - 1
		gen ddl_loans = dl_loans - dl_loans[_n-1]
		gen IO_appr = appr_occ_io + appr_inv_io
		gen dl_IO = IO_appr/IO_appr[_n-1] - 1
		gen ddl_IO = dl_IO - dl_IO[_n-1]
		gen PI_apr = tot_appr - IO_appr
		gen dl_PI = PI_apr/PI_apr[_n-1] - 1
		gen ddl_PI = dl_PI - dl_PI[_n-1]
		* regenerate policy dummy lags
		foreach lag in 1 2 3 4 {
			gen MP1_`lag' = MacP1[_n-`lag']
			gen dMP1_`lag' = MP1_`lag' - MP1_`lag'[_n-1]
			gen MP2_`lag' = MacP2[_n-`lag']
			gen dMP2_`lag' = MP2_`lag' - MP2_`lag'[_n-1]
		}
		*Regenerate DV lags
		foreach x in `1' {
			gen `x'_l1 = `x'[_n-1]
			gen `x'_l2 = `x'[_n-2]
		}
		*Generate differences for control variables
		foreach x in lcapitalratio lfunding GDP houseprice qtr_dum1 qtr_dum2 qtr_dum3 qtr_dum4 {
			gen d`x' = `x' - `x'[_n-1]
		}
		*Regressions
		estimates clear
		foreach y of varlist `1' {
		  quietly regress `y' `y'_l1 `y'_l2 `2'_* dGDP dhouseprice dlcapitalratio dlfunding dqtr_dum*, vce(robust)
		  eststo `y'
		}
		esttab, label /// keep(dMP* dGDP dhouseprice dlcapitalratio dlfunding)  ///
		cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)
	restore	
end
*******************************************************************************
******************* INITIAL CODE FINISHED
*******************************************************************************

*** Summary statistics
estpost summarize dl_inv dl_OO dl_TotalIO dl_TotalPI dl_loans ///
d_spread_invpi d_spread_oopi d_diff_spread_invpi d_spread_invio_rep d_diff_spread_invio ///
lcapitalratio lfunding if MajorBank == 1

estpost summarize dl_inv dl_OO dl_TotalIO dl_TotalPI dl_loans ///
d_spread_invpi d_spread_oopi d_diff_spread_invpi d_spread_invio_rep d_diff_spread_invio ///
lcapitalratio lfunding if MajorBank == 0

centile dl_inv dl_OO dl_TotalIO dl_TotalPI dl_loans ///
d_spread_invpi d_spread_oopi d_diff_spread_invpi d_spread_invio_rep d_diff_spread_invio ///
lcapitalratio lfunding GDP houseprice dcashrate, centile(0 25 50 75 100)



*******************************************************************************
******************* POLICY 1 REGRESSIONS
*******************************************************************************
******************* P1 System-wide quantity effects
* First check that 2 lagged DVs is the right setting. We need no 2nd-order autocor (1st oprder is fine). https://blog.stata.com/2015/11/12/xtabond-cheat-sheet/
estimates clear
foreach lag in 1 2 {
	foreach y in dl_inv dl_OO dl_loans {
		quietly xtabond `y' l(1/4).MacP1  lcapitalratio lfunding GDP houseprice qtr_dum* ///
			if MajorBank == 1, lags(`lag') vce(robust) artests(2)
		display "lagged DVs:" `lag'
		estat abond
	}
}

estimates clear
foreach lag in 1 2 {
	foreach y in dl_inv dl_OO dl_loans {
		quietly xtabond `y' l(1/4).MacP1  lcapitalratio lfunding GDP houseprice qtr_dum* ///
			if policy1_qnt_banks == 1 & MajorBank == 0, lags(`lag') vce(robust) artests(2)
		display "lagged DVs:" `lag'
		estat abond
	}
}

* Dynamic panel regressions for all, majors and nonmajors
xtabond dl_inv l(1/4).MacP1 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if policy1_qnt_banks == 1, lags(2) vce(robust)

	
estimates clear
foreach y of varlist dl_inv dl_OO dl_loans {
  quietly xtabond `y' l(1/4).MacP1 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if policy1_qnt_banks == 1, lags(2) vce(robust)
  eststo `y'
}
foreach y of varlist dl_inv dl_OO dl_loans {
  quietly xtabond `y' l(1/4).MacP1 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if MajorBank == 1, lags(2) vce(robust)
  eststo `y'_2
}
foreach y of varlist dl_inv dl_OO dl_loans {
  quietly xtabond `y' l(1/4).MacP1 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if policy1_qnt_banks == 1 & MajorBank == 0, lags(2) vce(robust)
  eststo `y'_3
}
esttab, label /// keep(L*.MacP1 lcapitalratio lfunding GDP houseprice) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)


**** Analysing control variables for different mortgage types
estimates clear
foreach y of varlist dl_OOPI dl_InvPI {
  quietly xtabond `y' l(1/4).MacP1 l(1/4).MacP2 GDP houseprice lcapitalratio lfunding qtr_dum* ///
	if MajorBank == 1, lags(2) vce(robust)
  eststo `y'
  quietly xtabond `y' l(1/4).MacP1 l(1/4).MacP2 GDP houseprice lcapitalratio lfunding qtr_dum* ///
	if MajorBank == 0 & (policy1_qnt_banks == 1 | policy2_qnt_banks == 1), lags(2) vce(robust)
  eststo `y'_2
}
quietly xtabond dl_OOIO l(1/4).MacP1 l(1/4).MacP2 GDP houseprice lcapitalratio lfunding qtr_dum* ///
  if MajorBank == 1, lags(2) vce(robust)
eststo `y'
quietly xtabond dl_OOIO l(1/4).MacP1 l(1/4).MacP2 GDP houseprice lcapitalratio lfunding qtr_dum2 qtr_dum3 ///
  if MajorBank == 0 & (policy1_qnt_banks == 1 | policy2_qnt_banks == 1), lags(2) vce(robust)
eststo `y'_2
quietly xtabond dl_InvIO l(1/4).MacP1 l(1/4).MacP2 GDP houseprice lcapitalratio lfunding qtr_dum* ///
  if MajorBank == 1, lags(2) vce(robust)
eststo `y'
quietly xtabond dl_InvIO l(1/4).MacP1 l(1/4).MacP2 GDP houseprice lcapitalratio lfunding qtr_dum* ///
  if MajorBank == 0 & (policy1_qnt_banks == 1 | policy2_qnt_banks == 1), lags(2) vce(robust)
eststo `y'_2
esttab, label keep(lcapitalratio lfunding GDP houseprice) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)


******************* P1 System-wide interest rate effects
*AB is giving a multicolinearity problem. Works without AB. See here for discussion of AB instrument singularity https://www.statalist.org/forums/forum/general-stata-discussion/general/1357392-gmm-warning-what-does-this-mean
*Instead use first differences in spreads with FE. Justifiable because spread are close to I(1). Gives similar results to including lagged DV instead of differencing. 
estimates clear
foreach y of varlist d_spread_invpi d_spread_oopi d_diff_spread_invpi {
	quietly reghdfe `y' l(1/4).MacP1 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if MajorBank == 1, absorb(bank) vce(cluster qtr) //residuals(invpol_FE_res_`y')
  eststo `y'_1
}
foreach y of varlist d_spread_invpi d_spread_oopi d_diff_spread_invpi {
  quietly reghdfe `y' l(1/4).MacP1 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy1_int_banks == 1 & MajorBank == 0, absorb(bank) vce(cluster bank qtr)
  eststo `y'_2
}
esttab, label keep(L*.MacP1) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)

	
	
******************* P1 Variable treatment intensity effects
*********** Quantities

estimates clear
foreach m of varlist dl_inv dl_OO dif_gr_inv_occ {
	quietly reghdfe `m' MacP1_intens_1 MacP1_intens_2 MacP1_intens_3 MacP1_intens_4 lcapitalratio lfunding /// 
	if policy1_qnt_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_dp_`m')
	eststo `m'
}
foreach m of varlist dl_inv dl_OO dif_gr_inv_occ {
	quietly reghdfe `m' MacP1_dum_abv_1 MacP1_dum_abv_2 MacP1_dum_abv_3 MacP1_dum_abv_4 lcapitalratio lfunding /// 
	if policy1_qnt_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_fe_`m')
	eststo `m'_2
}
esttab, label keep(MacP1_intens_* MacP1_dum_abv_*) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)
*xtline res_dp*

*********** Interest rates
estimates clear
foreach m of varlist d_spread_invpi d_spread_oopi d_diff_spread_invpi  {
	quietly reghdfe `m' MacP1_intens_1 MacP1_intens_2 MacP1_intens_3 MacP1_intens_4 lcapitalratio lfunding /// 
	if policy1_int_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_dp_`m')
	eststo `m'
}
foreach m of varlist d_spread_invpi d_spread_oopi d_diff_spread_invpi  {
	quietly reghdfe `m' MacP1_dum_abv_1 MacP1_dum_abv_2 MacP1_dum_abv_3 MacP1_dum_abv_4 lcapitalratio lfunding /// 
	if policy1_int_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_fe_`m')
	eststo `m'_2
}
esttab, label keep(MacP1_intens_* MacP1_dum_abv_*) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)




*******************************************************************************
******************* POLICY 2 REGRESSIONS
*******************************************************************************
******************* P2 System-wide quantity effects
* Check number of lags for AB
estimates clear
foreach lag in 1 2 {
	foreach y in dl_TotalIO dl_TotalPI dl_loans {
		quietly xtabond `y' l(1/4).MacP2  lcapitalratio lfunding GDP houseprice qtr_dum* ///
			if policy2_qnt_banks == 1, lags(`lag') vce(robust) artests(2)
		display "lagged DVs:" `lag'
		estat abond
	}
}
* Dynamic panel regressions for all, majors and nonmajors
xtabond dl_inv l(1/4).MacP2 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if policy2_qnt_banks == 1, lags(2) vce(robust)
	
estimates clear
foreach y of varlist dl_TotalIO dl_TotalPI dl_loans {
  quietly xtabond `y' l(1/4).MacP2 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if policy2_qnt_banks == 1, lags(2) vce(robust)
  eststo `y'
}
foreach y of varlist dl_TotalIO dl_TotalPI dl_loans {
  quietly xtabond `y' l(1/4).MacP2 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if MajorBank == 1, lags(2) vce(robust)
  eststo `y'_2
}
* Looks like we can use all seasonal dummies, maybe because only one lagged DV.
foreach y of varlist dl_TotalIO dl_TotalPI dl_loans {
  quietly xtabond `y' l(1/4).MacP2 lcapitalratio lfunding GDP houseprice qtr_dum* ///
	if policy2_qnt_banks == 1 & MajorBank == 0, lags(2) vce(robust)
  eststo `y'_3
}
esttab, label ///keep(L*.MacP2 lcapitalratio lfunding GDP houseprice) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)



******************* P2 System-wide interest rate effects
*AB is giving a multicolinearity problem. Works without AB. See here for discussion of AB instrument singularity https://www.statalist.org/forums/forum/general-stata-discussion/general/1357392-gmm-warning-what-does-this-mean
*Instead use first differences in spreads with FE. Justifiable because spread are close to I(1). Gives similar results to including lagged DV instead of differencing. 
estimates clear
foreach y of varlist d_spread_invio_rep d_spread_invpi d_diff_spread_invio {
	quietly reghdfe `y' l(1/4).MacP2 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if MajorBank == 1, absorb(bank) vce(cluster qtr) //residuals(invpol_FE_res_`y')
  eststo `y'_1
}
foreach y of varlist d_spread_invio_rep d_spread_invpi d_diff_spread_invio {
  quietly reghdfe `y' l(1/4).MacP2 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy2_int_banks == 1 & MajorBank == 0, absorb(bank) vce(cluster bank qtr)
  eststo `y'_2
}
esttab, label keep(L*.MacP2 dcashrate L.dcashrate) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)

* RObustness - without replacement
estimates clear
foreach y of varlist d_spread_invio d_spread_invpi {
	quietly reghdfe `y' l(1/4).MacP2 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if MajorBank == 1, absorb(bank) vce(cluster qtr) //residuals(invpol_FE_res_`y')
  eststo, title("majors")
}
foreach y of varlist d_spread_invio d_spread_invpi {
  quietly reghdfe `y' l(1/4).MacP2 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy2_int_banks == 1 & MajorBank == 0, absorb(bank) vce(cluster bank qtr)
  eststo, title("nonmajors")
}
esttab, label keep(L*.MacP2 dcashrate L.dcashrate) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)

* Do occio spreads rise in Q2 2017 too?
estimates clear
foreach y of varlist d_spread_invio_rep d_spread_oopi d_diff_spread_invio {
	quietly reghdfe `y' l(1/4).MacP2 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if MajorBank == 1, absorb(bank) vce(cluster qtr) //residuals(invpol_FE_res_`y')
  eststo `y'_1
}
foreach y of varlist d_spread_invio_rep d_spread_oopi d_diff_spread_invio {
  quietly reghdfe `y' l(1/4).MacP2 lcapitalratio lfunding l(0/1).dcashrate GDP houseprice qtr_dum* ///
	if policy2_int_banks == 1 & MajorBank == 0, absorb(bank) vce(cluster bank qtr)
  eststo `y'_2
}
esttab, label keep(L*.MacP2 dcashrate L.dcashrate) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)





******************* P2 Variable treatment intensity effects
*********** Quantities
estimates clear
foreach m of varlist dl_TotalIO dl_TotalPI dif_gr_io_pi {
	quietly reghdfe `m' MacP2_intens_1 MacP2_intens_2 MacP2_intens_3 MacP2_intens_4 lcapitalratio lfunding /// 
	if policy2_qnt_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_dp_`m')
	eststo `m'
}
foreach m of varlist dl_TotalIO dl_TotalPI dif_gr_io_pi {
	quietly reghdfe `m' MacP2_dum_abv_1 MacP2_dum_abv_2 MacP2_dum_abv_3 MacP2_dum_abv_4 lcapitalratio lfunding /// 
	if policy2_qnt_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_fe_`m')
	eststo `m'_2
}
esttab, label keep(MacP2_intens_* MacP2_dum_abv_*) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)
*xtline res_dp*

*********** Interest rates
estimates clear
foreach m of varlist d_spread_invio d_spread_invpi d_diff_spread_invio  {
	quietly reghdfe `m' MacP2_intens_1 MacP2_intens_2 MacP2_intens_3 MacP2_intens_4 lcapitalratio lfunding /// 
	if policy2_int_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_dp_`m')
	eststo `m'
}
foreach m of varlist d_spread_invio d_spread_invpi d_diff_spread_invio  {
	quietly reghdfe `m' MacP2_dum_abv_1 MacP2_dum_abv_2 MacP2_dum_abv_3 MacP2_dum_abv_4 lcapitalratio lfunding /// 
	if policy2_int_banks == 1, absorb(bank period) vce(cluster bank qtr) //residual(res_fe_`m')
	eststo `m'_2
}
esttab, label keep(MacP2_intens_* MacP2_dum_abv_*) ///
cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)



***************Aggregates analysis
***************Aggregates analysis
***************Aggregates analysis


* Generate major share for change in credit.
gen dif_mort_outs = outs_tot_closbal - outs_tot_closbal[_n-1]
gen dif_maj_mort_outs = dif_mort_outs * MajorBank

* Smooth the large bank's Q2 2016 spike in mortgage interest income
replace int_inc_hous_loans = 3.3621e9 if bank == "NAB" & (period == "2016-03-31" | period == "2016-06-30")


* Collapse to the time series level
preserve
	collapse (sum) outs_tot_closbal outs_bus_total dif_mort_outs dif_maj_mort_outs int_inc_hous_loans ///
	(mean) hous_gr occ_gr inv_gr bus_gr majsh_mortintinc lcapitalratio lfunding MacP1 MacP2 dcashrate cr_qe GDP houseprice ///
	qtr_dum*, by(qtr period)
	
	gen mort_int_inc = int_inc_hous_loans/1e9
	gen majsh_mort_gr = dif_maj_mort_outs/dif_mort_outs
	gen majsh_mii_gr = 100*(majsh_mortintinc/majsh_mortintinc[_n-1] - 1)
	* Regenerate policy lags
	foreach lag in 1 2 3 4 {
		gen MP1_`lag' = MacP1[_n-`lag']
		gen MP2_`lag' = MacP2[_n-`lag']
	}
	* Lagged DVs and other variables
	foreach x in hous_gr bus_gr mort_int_inc majsh_mortintinc majsh_mii_gr majsh_mort_gr cr_qe dcashrate {
		gen `x'_l1 = `x'[_n-1]
		gen `x'_l2 = `x'[_n-2]
	}
	
	* Run regressions
	foreach y in hous_gr bus_gr mort_int_inc majsh_mii_gr majsh_mort_gr {
		quietly regress `y' `y'_l1 MP1_* MP2_* GDP houseprice cr_qe cr_qe_l1 cr_qe_l2 dcashrate dcashrate_l1 lcapitalratio lfunding qtr_dum*, vce(robust)
		eststo `y'
	}
	esttab, label /// keep(dMP* dGDP dhouseprice dlcapitalratio dlfunding)  ///
	cells(b(star fmt(3)) se(fmt(3))) stats(r2 N) starlevels(* 0.1 ** 0.05 *** 0.01)
	
	*Mortgage credit growth
	gen placq_x = .
	drop placq*
	gen plac_mc_up1CI = .
	gen plac_mc_up5CI = .
	gen plac_mc_coef = .
	gen plac_mc_lw5CI = .
	gen plac_mc_lw1CI = .
	forvalues q = 200(1)238 {
		gen placq_`q' = 0
		replace placq_`q' = 1 if qtr == `q'
		quietly regress hous_gr hous_gr_l1 placq_`q' ///
		GDP houseprice dcashrate dcashrate_l1 lcapitalratio lfunding qtr_dum*, vce(robust)
		lincom placq_`q'
		replace plac_mc_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
		replace plac_mc_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
		replace plac_mc_coef = r(estimate) if qtr == `q'
		replace plac_mc_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
		replace plac_mc_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
	}
	tsline plac_mc_up1CI plac_mc_coef plac_mc_lw1CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
	*Business credit growth
	gen placq_x = .
	drop placq*
	gen plac_bc_up1CI = .
	gen plac_bc_up5CI = .
	gen plac_bc_coef = .
	gen plac_bc_lw5CI = .
	gen plac_bc_lw1CI = .
	forvalues q = 200(1)238 {
		gen placq_`q' = 0
		replace placq_`q' = 1 if qtr == `q'
		quietly regress bus_gr bus_gr_l1 placq_`q' ///
		GDP houseprice dcashrate dcashrate_l1 lcapitalratio lfunding qtr_dum*, vce(robust)
		lincom placq_`q'
		replace plac_bc_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
		replace plac_bc_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
		replace plac_bc_coef = r(estimate) if qtr == `q'
		replace plac_bc_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
		replace plac_bc_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
	}
	tsline plac_bc_up1CI plac_bc_coef plac_bc_lw1CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
	*Mortgage interest income
	gen placq_x = .
	drop placq*
	gen plac_mi_up1CI = .
	gen plac_mi_up5CI = .
	gen plac_mi_coef = .
	gen plac_mi_lw5CI = .
	gen plac_mi_lw1CI = .
	forvalues q = 200(1)238 {
		gen placq_`q' = 0
		replace placq_`q' = 1 if qtr == `q'
		quietly regress mort_int_inc mort_int_inc_l1 placq_`q' ///
		GDP houseprice cr_qe cr_qe_l1 lcapitalratio lfunding qtr_dum*, vce(robust)
		lincom placq_`q'
		replace plac_mi_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
		replace plac_mi_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
		replace plac_mi_coef = r(estimate) if qtr == `q'
		replace plac_mi_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
		replace plac_mi_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
	}
	tsline plac_mi_up1CI plac_mi_coef plac_mi_lw1CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
	*Majors' share of mortgage itnerest income
	gen placq_x = .
	drop placq*
	gen plac_msmi_up1CI = .
	gen plac_msmi_up5CI = .
	gen plac_msmi_coef = .
	gen plac_msmi_lw5CI = .
	gen plac_msmi_lw1CI = .
	forvalues q = 200(1)238 {
		gen placq_`q' = 0
		replace placq_`q' = 1 if qtr == `q'
		quietly regress majsh_mortintinc majsh_mortintinc_l1 placq_`q' ///
		GDP houseprice dcashrate dcashrate_l1 lcapitalratio lfunding qtr_dum*, vce(robust)
		lincom placq_`q'
		replace plac_msmi_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
		replace plac_msmi_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
		replace plac_msmi_coef = r(estimate) if qtr == `q'
		replace plac_msmi_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
		replace plac_msmi_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
	}
	tsline plac_msmi_up1CI plac_msmi_coef plac_msmi_lw1CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
	*Majors' share of change in mortgage credit
	gen placq_x = .
	drop placq*
	gen plac_msmc_up1CI = .
	gen plac_msmc_up5CI = .
	gen plac_msmc_coef = .
	gen plac_msmc_lw5CI = .
	gen plac_msmc_lw1CI = .
	forvalues q = 200(1)238 {
		gen placq_`q' = 0
		replace placq_`q' = 1 if qtr == `q'
		quietly regress majsh_mort_gr majsh_mort_gr_l1 placq_`q' ///
		GDP houseprice dcashrate dcashrate_l1 lcapitalratio lfunding qtr_dum*, vce(robust)
		lincom placq_`q'
		replace plac_msmc_up1CI = r(estimate) + invnormal(0.995)*r(se) if qtr == `q'
		replace plac_msmc_up5CI = r(estimate) + invnormal(0.975)*r(se) if qtr == `q'
		replace plac_msmc_coef = r(estimate) if qtr == `q'
		replace plac_msmc_lw5CI = r(estimate) + invnormal(0.025)*r(se) if qtr == `q'
		replace plac_msmc_lw1CI = r(estimate) + invnormal(0.005)*r(se) if qtr == `q'
	}
	tsline plac_msmc_up1CI plac_msmc_coef plac_msmc_lw1CI if qtr >= 198 & qtr <= 300, sort ///
	lcolor(black black black) lpattern(shortdash solid shortdash) lwidth(thin medium thin) ///
	yline(0) legend(order(2 "coefficient on quarterly indicator" 1 "95% confidence interval")) ///
	xtick(200(4)238, tlength(2)) tlabel(200(4)238, format(%tqCY)) xtitle("") 
	
	* Export the data
	outsheet period hous_gr inv_gr occ_gr bus_gr mort_int_inc majsh_mortintinc majsh_mii_gr majsh_mort_gr plac_* using "agg_analysis_rolling_regressions.csv", comma
restore	

